	'
        ' Camelot Knights 2
	'
	' (c) Copyright 2024 Oscar Toledo G.
	' https://nanochess.org/
	'
	' Music by Adan Toledo G.
	'
	' Example for demonstration of the CVBasic capabilities.
	'
        ' Creation date: Mar/15/2024. A full remake of Camelot Knights.
	'

	ON FRAME GOSUB play_sound

	DIM enemy_x(7), enemy_y(7), enemy_t(7), enemy_s(7), enemy_d(7)

	PLAY SIMPLE

	'
	' Show the title screen.
	'
title_screen:
        MODE 1

        SCREEN DISABLE
        DEFINE VRAM PLETTER 0,$1800,camelot_title_bitmap
        DEFINE VRAM PLETTER $2000,$1800,camelot_title_color
        SCREEN ENABLE
        BORDER 4
	PLAY music_title

        DO
                WAIT
		c = RANDOM	' Make CVBasic random generator to run
        LOOP WHILE CONT = 0
	
	SCREEN DISABLE
	PLAY OFF
	WAIT
	WAIT

        MODE 0
	DEFINE CHAR 96,5,game_bitmaps
	DEFINE COLOR 96,5,game_colors
        DEFINE SPRITE 0,64,game_sprites

	'
	' Start the game.
	'
	CLS
	lives = 3
	PRINT AT 736,"SCORE:"
	#score = 0
	GOSUB update_score
	PRINT AT 756,"LIVES: ` ` `"
	'
	' Restart level.
	'
restart_level:
	#offset = $18a0
	player_x = 120
	player_y = 144
	FOR c = 0 TO 6
		enemy_t(c) = 0
	NEXT c
	PLAY music_game
	scroll_map = -1

	'
	' Main game loop.
	' 
game_loop:
	'
	' Synchronize with video frame.
	'
	WAIT
	'
	' Scroll the map each 16 video frames.
	'
	scroll_map = (scroll_map + 1) % 16
	IF scroll_map = 0 THEN
		' Update in chunks to avoid interrupting music.
		SCREEN level_data,#offset,0,32,8,32
		SCREEN level_data,#offset+256,256,32,8,32
		SCREEN level_data,#offset+512,512,32,7,32

	        #offset = #offset - 32
		IF #offset = 0 THEN GOTO boss_section
	END IF

	'
	' Create enemies randomly
	'
	IF next_enemy = 0 THEN
		FOR c = 0 TO 2	' Look for space
			IF enemy_t(c) = 0 THEN
				enemy_y(c) = 241
				enemy_x(c) = RANDOM(208) + 16
				enemy_t(c) = RANDOM(2) + 1	' Enemy type 1 or 2.
				enemy_s(c) = 0
				EXIT FOR
			END IF
		NEXT c
		next_enemy = RANDOM(16) + 16
	ELSE
		next_enemy = next_enemy - 1
	END IF

	'
	' Handle enemies (sprite pair)
	'
	FOR c = 0 TO 2
		spr_vdp = c * 2 + 4
		IF enemy_t(c) = 0 THEN	' Enemy inactive
			SPRITE spr_vdp, $d1, 0, 0, 0
			SPRITE spr_vdp + 1, $d1, 0, 0, 0
		ELSE
			spr_frame = (FRAME AND 8) / 2 + 32
			IF enemy_t(c) = 1 THEN	' Walking enemy
				IF enemy_y(c) >= 32 THEN
					IF player_x < enemy_x(c) THEN
						enemy_x(c) = enemy_x(c) - 1
					ELSEIF player_x > enemy_x(c) THEN
						enemy_x(c) = enemy_x(c) + 1
					END IF
				END IF
				enemy_y(c) = enemy_y(c) + 1
				IF enemy_y(c) = 176 THEN enemy_t(c) = 0
				SPRITE spr_vdp, enemy_y(c), enemy_x(c), spr_frame, 8
				SPRITE spr_vdp + 1, enemy_y(c), enemy_x(c), spr_frame + 16, 15
			ELSE	' Flying enemy
				IF enemy_s(c) < 32 THEN		' Entering
					enemy_y(c) = enemy_y(c) + 1
					enemy_s(c) = enemy_s(c) + 1
				ELSEIF enemy_s(c) < 160 THEN	' Fly in circles
					enemy_x(c) = enemy_x(c) + circle_x(enemy_s(c) - 32)
					enemy_y(c) = enemy_y(c) + circle_y(enemy_s(c) - 32)
					enemy_s(c) = enemy_s(c) + 1
					IF enemy_s(c) = 63 THEN	' Enemy shoots!
						IF enemy_t(c + 3) = 0 THEN
							enemy_t(c + 3) = 10
							enemy_x(c + 3) = enemy_x(c)
							enemy_y(c + 3) = enemy_y(c)
							IF player_x < enemy_x(c) THEN
								enemy_d(c + 3) = -1
							ELSE
								enemy_d(c + 3) = 1
							END IF
							sound_effect = 2: sound_state = 0
						END IF
					END IF
				ELSE				' Attack
					IF player_x < enemy_x(c) THEN
						enemy_x(c) = enemy_x(c) - 1
					ELSEIF player_x > enemy_x(c) THEN
						enemy_x(c) = enemy_x(c) + 1
					END IF
					enemy_y(c) = enemy_y(c) + 1
					IF enemy_y(c) = 176 THEN enemy_t(c) = 0
				END IF
				SPRITE spr_vdp, enemy_y(c), enemy_x(c), spr_frame + 8, 13
				SPRITE spr_vdp + 1, enemy_y(c), enemy_x(c), spr_frame + 24, 15
			END IF

			'
			' Check collision against the player
			'
			#bx = enemy_x(c)
			#by = enemy_y(c)
			IF ABS(#bx - player_x) < 8 THEN
				IF ABS(#by - player_y) < 8 THEN
					GOTO player_dies
				END IF
			END IF
		END IF
	NEXT c

	GOSUB move_shots

	IF player_hit THEN GOTO player_dies

	GOSUB move_player

	GOTO game_loop

	'
	' Boss section.
	'
boss_section:
	PLAY music_boss
	SPRITE 4,$D1,0,0,0
	SPRITE 5,$D1,0,0,0
	SPRITE 6,$D1,0,0,0
	SPRITE 7,$D1,0,0,0
	SPRITE 8,$D1,0,0,0
	SPRITE 9,$D1,0,0,0

	FOR c = 0 TO 2
		enemy_t(c) = 0
	NEXT c

	boss_x = 120
	boss_y = 0
	boss_dir = 1
	boss_hits = 0
	boss_color = 8

	'
	' The boss enters the screen.
	'
	FOR count = 0 TO 32
		WAIT
		GOSUB draw_boss
		GOSUB move_shots
		IF player_hit THEN GOTO player_dies
		GOSUB move_player
		WAIT
		GOSUB draw_boss
		GOSUB move_shots
		IF player_hit THEN GOTO player_dies
		GOSUB move_player
		boss_y = boss_y + 1
	NEXT count
	
	'
	' Main loop for boss.
	'
boss_loop:
	WAIT

	'
	' Move boss left and right.
	'
	IF FRAME AND 1 THEN
		IF boss_dir = 1 THEN
			boss_x = boss_x - 1
			boss_y = boss_y + boss_oscillate(boss_x % 8)
			IF boss_x = 16 THEN boss_dir = 0
		ELSE
			boss_x = boss_x + 1
			boss_y = boss_y + boss_oscillate(boss_x % 8)
			IF boss_x = 208 THEN boss_dir = 1
		END IF
	END IF

	'
	' Shoot at player.
	'
	IF (RANDOM AND 7) = 0 THEN
		FOR c = 3 TO 5
			IF enemy_t(c) = 0 THEN	' Free slot for fire?
				enemy_t(c) = 7
				enemy_x(c) = boss_x
				enemy_y(c) = boss_y + 8
				IF player_x < boss_x THEN
					enemy_d(c) = -1
				ELSE
					enemy_d(c) = 1
				END IF
				sound_effect = 2: sound_state = 0
				EXIT FOR
			END IF
		NEXT c
	END IF

	'
	' Detect if the player hits the boss
	'
	IF enemy_t(6) THEN
		IF ABS(boss_x + 1 - enemy_x(6)) < 8 THEN
			IF ABS(boss_y + 1 - enemy_y(6)) < 8 THEN
				enemy_t(6) = 0
				sound_effect = 3: sound_state = 0
				boss_hits = boss_hits + 1
				IF boss_hits = 10 THEN GOTO boss_defeated
			END IF
		END IF
	END IF

	boss_color = 8: IF sound_effect = 3 THEN boss_color = 10
	GOSUB draw_boss
	GOSUB move_shots
	IF player_hit THEN GOTO player_dies
	GOSUB move_player

	GOTO boss_loop

	'
	' Boss defeated.
	'
boss_defeated:
	sound_effect = 5: sound_state = 0
	FOR c = 0 TO 120
		WAIT
		d = FRAME AND 3
		IF d = 0 THEN boss_color = 4
		IF d = 1 THEN boss_color = 10
		IF d = 2 THEN boss_color = 15
		IF d = 3 THEN boss_color = 10
		GOSUB draw_boss
	NEXT c
	#score = #score + 1000
	GOSUB update_score

	SPRITE 4,$d1,0,0,0
	SPRITE 5,$d1,0,0,0
	SPRITE 6,$d1,0,0,0
	SPRITE 7,$d1,0,0,0
	SPRITE 8,$d1,0,0,0

	PLAY OFF

	FOR c = 0 TO 120
		WAIT
	NEXT c
	GOTO game_won

	'
	' Vertical oscillation for boss.
	'
boss_oscillate:
	DATA BYTE $FF,$FF,$FF,$00,$00,$01,$01,$01

	'
	' Color for single sprite enemies (bullets) including blinking.
	'
enemy_colors:
	DATA BYTE 10,10
	DATA BYTE 10,10
	DATA BYTE 11,11
	DATA BYTE 14,14
	DATA BYTE 6,10
	DATA BYTE 15,14
	DATA BYTE 15,15
	DATA BYTE 13,15

	'
	' Relative adjustments to make enemies fly in circles.
	'
circle_x:
	DATA BYTE $00,$01,$02,$01,$02,$01,$01,$02
	DATA BYTE $01,$01,$01,$01,$00,$01,$00,$00
	DATA BYTE $00,$00,$00,$00,$ff,$00,$ff,$ff
	DATA BYTE $ff,$ff,$fe,$ff,$ff,$fe,$ff,$fe
	DATA BYTE $ff,$ff,$fe,$ff,$fe,$ff,$ff,$fe
	DATA BYTE $ff,$ff,$ff,$ff,$00,$ff,$00,$00
	DATA BYTE $00,$00,$00,$00,$01,$00,$01,$01
	DATA BYTE $01,$01,$02,$01,$01,$02,$01,$02
	DATA BYTE $01,$01,$02,$01,$02,$01,$01,$02
	DATA BYTE $01,$01,$01,$01,$00,$01,$00,$00
	DATA BYTE $00,$00,$00,$00,$ff,$00,$ff,$ff
	DATA BYTE $ff,$ff,$fe,$ff,$ff,$fe,$ff,$fe
	DATA BYTE $ff,$ff,$fe,$ff,$fe,$ff,$ff,$fe
	DATA BYTE $ff,$ff,$ff,$ff,$00,$ff,$00,$00
	DATA BYTE $00,$00,$00,$00,$01,$00,$01,$01
	DATA BYTE $01,$01,$02,$01,$01,$02,$01,$02

circle_y:
	DATA BYTE $00,$01,$00,$00,$01,$00,$01,$01
	DATA BYTE $01,$01,$02,$01,$01,$02,$01,$02
	DATA BYTE $01,$01,$02,$01,$02,$01,$01,$02
	DATA BYTE $01,$01,$01,$01,$00,$01,$00,$00
	DATA BYTE $00,$00,$00,$00,$ff,$00,$ff,$ff
	DATA BYTE $ff,$ff,$fe,$ff,$ff,$fe,$ff,$fe
	DATA BYTE $ff,$ff,$fe,$ff,$fe,$ff,$ff,$fe
	DATA BYTE $ff,$ff,$ff,$ff,$00,$ff,$00,$00
	DATA BYTE $00,$00,$00,$00,$01,$00,$01,$01
	DATA BYTE $01,$01,$02,$01,$01,$02,$01,$02
	DATA BYTE $01,$01,$02,$01,$02,$01,$01,$02
	DATA BYTE $01,$01,$01,$01,$00,$01,$00,$00
	DATA BYTE $00,$00,$00,$00,$ff,$00,$ff,$ff
	DATA BYTE $ff,$ff,$fe,$ff,$ff,$fe,$ff,$fe
	DATA BYTE $ff,$ff,$fe,$ff,$fe,$ff,$ff,$fe
	DATA BYTE $ff,$ff,$ff,$ff,$00,$ff,$00,$00

	'
	' Player dies.
	'
player_dies:
	PLAY OFF
	sound_effect = 4: sound_state = 0

	'
	' Stop the game so it can be seen where the player was hit.
	'
	FOR c = 0 TO 30
		WAIT
	NEXT c

	'
	' Turn into skeleton.
	'
	player_frame = 76
	SPRITE 0, player_y, player_x, player_frame, 1	' Black
	SPRITE 1, player_y, player_x, player_frame + 16, 15	' White
	SPRITE 2, $d1, 0, 0, 0
	SPRITE 3, $d1, 0, 0, 0

	FOR c = 4 TO 31
		SPRITE c, $d1, 0, 0, 0
	NEXT c

	FOR c = 0 TO 6
		enemy_t(c) = 0
	NEXT c

	FOR c = 0 TO 60
		WAIT
	NEXT c

	IF lives = 0 THEN
		PRINT AT 10 * 32 + 10," GAME OVER "
		FOR c = 0 TO 240
			WAIT
		NEXT c
		GOTO title_screen
	END IF

	lives = lives - 1
	PRINT AT 763 + lives * 2," "
	GOTO restart_level

	'
	' Game won.
	'
game_won:
	player_frame = 72
	SPRITE 0, player_y, player_x, player_frame, 1	' Black
	SPRITE 1, player_y, player_x, player_frame + 16, 15	' White
	SPRITE 2, player_y, player_x, player_frame + 32, 7	' Cyan
	SPRITE 3, player_y, player_x, player_frame + 36, 9	' Pink
	PRINT AT 10 * 32 + 11, " YOU WIN! "
	FOR c = 0 TO 240
		WAIT
	NEXT c
	GOTO title_screen

	'
	' Update the score.
	'
update_score:	PROCEDURE
	PRINT AT 742,#score
	END

	'
	' Draw the boss.
	' 32x32 pixels using 4 sprites.
	' Plus a 2nd color using one extra sprite.
 	'
draw_boss:	PROCEDURE
	IF FRAME AND 8 THEN boss_frame = 128 ELSE boss_frame = 144

	SPRITE 4,boss_y - 8, boss_x - 8, boss_frame, boss_color
	SPRITE 5,boss_y - 8, boss_x + 8, boss_frame + 4, boss_color
	SPRITE 6,boss_y + 8, boss_x - 8, boss_frame + 8, boss_color
	SPRITE 7,boss_y + 8, boss_x + 8, boss_frame + 12, boss_color

	IF boss_frame = 128 THEN
		SPRITE 8,boss_y, boss_x, 112, 1
	ELSE
		SPRITE 8,boss_y, boss_x, 116, 1
	END IF
	END

	'
	' Move the shots
	'
move_shots:	PROCEDURE
	player_hit = 0

	'
	' Handle shots (single sprite)
	'
	FOR c = 3 TO 6
		spr_vdp = c - 3 + 10
		IF enemy_t(c) = 0 THEN
			SPRITE spr_vdp, $d1, 0, 0, 0
		ELSE
			d = (enemy_t(c) - 3) * 2
			IF FRAME AND 4 THEN d = d + 1
			e = enemy_colors(d)	
			SPRITE spr_vdp, enemy_y(c), enemy_x(c), (enemy_t(c) - 3) * 4, e
			IF enemy_t(c) = 7 THEN	' Boss fire
				enemy_y(c) = enemy_y(c) + 2
				enemy_x(c) = enemy_x(c) + enemy_d(c)
				IF (enemy_x(c) = 0) + (enemy_x(c) = 255) THEN
					enemy_t(c) = 0
				END IF
				#bx = enemy_x(c)
				#by = enemy_y(c)
				IF ABS(#bx - player_x) < 8 THEN
					IF ABS(#by - player_y) < 8 THEN
						player_hit = 1
					END IF
				END IF
			ELSEIF enemy_t(c) = 8 THEN	' Magic
				enemy_y(c) = enemy_y(c) + 1
			ELSEIF enemy_t(c) = 9 THEN	' Sword
				IF enemy_y(c) < 4 THEN enemy_t(c) = 0
				enemy_y(c) = enemy_y(c) - 4
				#bx = enemy_x(c)
				#by = enemy_y(c)
				FOR d = 0 TO 2
					IF ABS(#bx - enemy_x(d)) < 8 THEN
						IF ABS(#by - enemy_y(d)) < 8 THEN
							IF (enemy_t(d) = 1) + (enemy_t(d) = 2) THEN
								IF enemy_t(d) = 1 THEN
									#score = #score + 50
								ELSE
									#score = #score + 75
								END IF
								GOSUB update_score
								sound_effect = 3: sound_state = 0
								enemy_t(d) = 0
								enemy_t(c) = 3
							END IF
						END IF
					END IF
				NEXT d
			ELSEIF enemy_t(c) = 10 THEN	' Enemy bullet
				enemy_y(c) = enemy_y(c) + 2
				enemy_x(c) = enemy_x(c) + enemy_d(c)
				IF (enemy_x(c) = 0) + (enemy_x(c) = 255) THEN
					enemy_t(c) = 0
				END IF
				#bx = enemy_x(c)
				#by = enemy_y(c)
				IF ABS(#bx - player_x) < 8 THEN
					IF ABS(#by - player_y) < 8 THEN
						player_hit = 1
					END IF
				END IF
			ELSE	' Explosion
				IF (FRAME AND 3) = 0 THEN
					enemy_t(c) = enemy_t(c) + 1
					IF enemy_t(c) = 7 THEN enemy_t(c) = 0
				END IF
			END IF
			IF enemy_y(c) >= 176 THEN
				enemy_t(c) = 0	
			END IF
		END IF
	NEXT c
	END

	'
	' Move the player
	'
move_player:	PROCEDURE
	IF CONT.UP THEN IF player_y > 96 THEN player_y = player_y - 1
	IF CONT.DOWN THEN IF player_y < 144 THEN player_y = player_y + 1
	IF CONT.LEFT THEN IF player_x > 0 THEN player_x = player_x - 1
	IF CONT.RIGHT THEN IF player_x < 240 THEN player_x = player_x + 1
	IF CONT.BUTTON THEN
		IF enemy_t(6) = 0 THEN
			enemy_t(6) = 9
			enemy_x(6) = player_x
			enemy_y(6) = player_y - 8
			sound_effect = 1: sound_state = 0
		END IF
	END IF

	IF FRAME AND 8 THEN player_frame = 64 ELSE player_frame = 68
	SPRITE 0, player_y, player_x, player_frame, 1	' Black
	SPRITE 1, player_y, player_x, player_frame + 16, 15	' White
	SPRITE 2, player_y, player_x, player_frame + 32, 7	' Cyan
	SPRITE 3, $d1, 0, 0, 0
	END

game_bitmaps:
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "X..XX..X"
	BITMAP "XXXXXXXX"
	BITMAP "..XXXX.."
	BITMAP ".XX..XX."
	BITMAP "XXX..XXX"

	BITMAP "XXXXXXXX"
	BITMAP "XX.XXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXX.XX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXX.XXXX"
	BITMAP "XXXXXXXX"
	
	BITMAP "........"
	BITMAP "....XX.."
	BITMAP "........"
	BITMAP ".XX....."
	BITMAP "...X...."
	BITMAP "........"
	BITMAP "X......X"
	BITMAP "......X."

	BITMAP "XX.XXXXX"
	BITMAP "XXXXX.XX"
	BITMAP ".XXXXXXX"
	BITMAP "XXXXXX.X"
	BITMAP "XXX.XXXX"
	BITMAP "XXXXXXX."
	BITMAP "X.XXXXXX"
	BITMAP "XXXX.XXX"
	
	BITMAP "X..XXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP ".....XX."
	BITMAP "X..XX..X"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP ".XX....."

game_colors:
	DATA BYTE $91,$91,$91,$91,$E1,$E1,$E1,$E1
	DATA BYTE $C1,$C1,$C1,$C1,$C1,$C1,$C1,$C1
	DATA BYTE $14,$14,$14,$14,$14,$14,$14,$14
	DATA BYTE $C1,$C1,$C1,$C1,$C1,$C1,$C1,$C1
	DATA BYTE $61,$61,$61,$61,$61,$61,$61,$61

level_data:
	'          01234567890123456789012345678901
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	

        INCLUDE "camelot_title.bas"

        INCLUDE "camelot_sprites.bas"

	INCLUDE "camelot_music_boss.bas"	' Boss
	INCLUDE "camelot_music_game.bas"	' Game background
	INCLUDE "camelot_music_title.bas"	' Title screen

	'
	' Sound effect playing.
	'
play_sound:	PROCEDURE
	ON sound_effect GOSUB sound_none, sound_shoot1, sound_shoot2, sound_hit1, sound_hit2, sound_boss
	END

sound_none:	PROCEDURE
	SOUND 2,,0	' Colecovision/SG1000
	SOUND 7,,0	' Msx	
	END

sound_shoot1:	PROCEDURE
	SOUND 2,128 - sound_state * 4,12
	SOUND 7,128 - sound_state * 4,12
	sound_state = sound_state + 1
	IF sound_state = 16 THEN sound_effect = 0
	END

sound_shoot2:	PROCEDURE
	SOUND 2,320 - sound_state * 16,12
	SOUND 7,320 - sound_state * 16,12
	sound_state = sound_state + 1
	IF sound_state = 8 THEN sound_effect = 0
	END

sound_hit1:	PROCEDURE
	SOUND 2,640 + sound_state * 4,12
	SOUND 7,640 - sound_state * 4,12
	sound_state = sound_state + 1
	IF sound_state = 8 THEN sound_effect = 0
	END

sound_hit2:	PROCEDURE
	SOUND 2,320 + sound_state * 8,12
	SOUND 7,320 + sound_state * 8,12
	sound_state = sound_state + 1
	IF sound_state = 16 THEN sound_effect = 0
	END

sound_boss:	PROCEDURE
	IF sound_state AND 1 THEN
		SOUND 2,320 + sound_state * 8,12
		SOUND 7,320 + sound_state * 8,12
	ELSE
		SOUND 2,320 - sound_state * 8,12
		SOUND 7,320 - sound_state * 8,12
	END IF
	sound_state = sound_state + 1
	IF sound_state = 32 THEN sound_effect = 0
	END
